<?php

return [
    // System Settings Labels
    'system_settings' => 'System Settings',
    'menu' => 'Menu',
    'general' => 'General',
    'support_information' => 'Support Information',
    'cart_inventory_settings' => 'Cart & Inventory Settings',
    'item_saved_for_later_successfully' => 'Item saved for later successfully',
    'save_for_later_items_fetched_successfully' => 'Save for later items fetched successfully',
    'multi_store' => 'Multi Store',
    'single_store' => 'Single Store',
    'logout_successful' => 'Logout successful',
    'logout_failed' => 'Logout failed',
    'select_checkout_type' => 'Select Checkout Type',
    'cart_max_items_exceeded' => 'Cart max items exceeded',
    'minimum_cart_amount_not_met' => 'Minimum cart amount not met for :amount',
    'checkout_type_single_store_error' => 'Checkout type is single store. Please remove items from other stores to proceed.',
    'wallet_settings' => 'Wallet Settings',
    'maintenance_mode' => 'Maintenance Mode',
    'referral_earn_program' => 'Referral & Earn Program',
    'app_name' => 'App Name',
    'app_name_placeholder' => 'Enter App Name',
    'system_timezone' => 'System Timezone',
    'system_timezone_placeholder' => 'e.g., America/New_York',
    'copyright_details' => 'Copyright Details',
    'copyright_details_placeholder' => 'e.g., © 2025 App Name Inc. All rights reserved.',
    'logo' => 'Logo',
    'favicon' => 'Favicon',
    'seller_support_email' => 'Seller Support Email',
    'seller_support_email_placeholder' => 'Enter email',
    'seller_support_number' => 'Seller Support Number',
    'seller_support_number_placeholder' => 'Enter Mobile Number',
    'minimum_cart_amount' => 'Minimum Cart Amount',
    'minimum_cart_amount_placeholder' => 'Enter minimum cart amount',
    'maximum_items_allowed_in_cart' => 'Maximum Items Allowed in Cart',
    'maximum_items_allowed_in_cart_placeholder' => 'Enter maximum items allowed in cart',
    'low_stock_limit' => 'Low Stock Limit',
    'low_stock_limit_placeholder' => 'Enter low stock limit',
    'maximum_distance_to_nearest_store' => 'Maximum Distance to Nearest Store (in km)',
    'maximum_distance_to_nearest_store_placeholder' => 'Enter max distance to nearest store',
    'enable_wallet' => 'Enable Wallet',
    'welcome_wallet_balance_amount' => 'Welcome Wallet Balance Amount',
    'welcome_wallet_balance_amount_placeholder' => 'Enter welcome balance amount',
    'seller_app_maintenance_mode' => 'Seller App Maintenance Mode',
    'seller_app_maintenance_message' => 'Seller App Maintenance Message',
    'seller_app_maintenance_message_placeholder' => 'Enter maintenance message',
    'web_maintenance_mode' => 'Web Maintenance Mode',
    'web_maintenance_message' => 'Web Maintenance Message',
    'web_maintenance_message_placeholder' => 'Enter maintenance message',
    'enable_referral_program' => 'Enable Referral Program',
    'user_bonus_method' => 'User Bonus Method',
    'fixed' => 'Fixed',
    'percentage' => 'Percentage',
    'user_bonus' => 'User Bonus',
    'user_bonus_placeholder' => 'Enter user bonus',
    'max_bonus_amount_user' => 'Max Bonus Amount (User)',
    'max_bonus_amount_user_placeholder' => 'Enter max bonus for user',
    'referral_bonus_method' => 'Referral Bonus Method',
    'referral_bonus' => 'Referral Bonus',
    'referral_bonus_placeholder' => 'Enter referral bonus',
    'max_bonus_amount_referral' => 'Max Bonus Amount (Referral)',
    'max_bonus_amount_referral_placeholder' => 'Enter max bonus for referral',
    'minimum_order_amount_for_bonus' => 'Minimum Order Amount for Bonus',
    'minimum_order_amount_for_bonus_placeholder' => 'Enter minimum order amount',
    'number_of_times_bonus_applicable' => 'Number of Times Bonus is Applicable',
    'number_of_times_bonus_applicable_placeholder' => 'Enter number of times bonus is given',
    'submit' => 'Submit',
    'export' => 'Export',
    'customers' => 'Customers',

    // Web Settings Labels
    'web_settings' => 'Web Settings',
    'seo_settings' => 'SEO Settings',
    'social_media' => 'Social Media',
    'app_download_section' => 'App Download Section',
    'feature_sections' => 'Feature Sections',
    'scripts' => 'Scripts',
    'site_name' => 'Site Name',
    'site_name_placeholder' => 'Enter site name',
    'site_copyright' => 'Site Copyright',
    'site_copyright_placeholder' => 'e.g., © 2025 Site Name Inc. All rights reserved.',
    'support_number' => 'Support Number',
    'support_number_placeholder' => 'Enter support number',
    'support_email' => 'Support Email',
    'support_email_placeholder' => 'Enter support email',
    'address' => 'Address',
    'address_placeholder' => 'Enter address',
    'short_description' => 'Short Description',
    'short_description_placeholder' => 'Enter short description',
    'site_header_logo' => 'Site Header Logo',
    'site_header_dark_logo' => 'Site Header dark mode Logo',
    'site_header_logo_placeholder' => 'Upload site header logo',
    'site_footer_logo' => 'Site Footer Logo',
    'site_footer_logo_placeholder' => 'Upload site footer logo',
    'site_favicon' => 'Site Favicon',
    'site_favicon_placeholder' => 'Upload site favicon',
    'header_script' => 'Header Script',
    'header_script_placeholder' => 'Enter header script',
    'footer_script' => 'Footer Script',
    'footer_script_placeholder' => 'Enter footer script',
    'google_map_key' => 'Google Map Key',
    'google_map_key_placeholder' => 'Enter Google Map API key',
    'map_iframe' => 'Map Iframe',
    'map_iframe_placeholder' => 'Enter map iframe code',
    'app_section_title' => 'App Section Title',
    'app_section_title_placeholder' => 'Enter app section title',
    'app_section_tagline' => 'App Section Tagline',
    'app_section_tagline_placeholder' => 'Enter app section tagline',
    'app_section_playstore_link' => 'Play Store Link',
    'app_section_playstore_link_placeholder' => 'Enter Play Store link',
    'app_section_appstore_link' => 'App Store Link',
    'app_section_appstore_link_placeholder' => 'Enter App Store link',
    'app_section_short_description' => 'App Section Short Description',
    'app_section_short_description_placeholder' => 'Enter app section short description',
    'facebook_link' => 'Facebook Link',
    'facebook_link_placeholder' => 'Enter Facebook link',
    'instagram_link' => 'Instagram Link',
    'instagram_link_placeholder' => 'Enter Instagram link',
    'x_link' => 'X Link',
    'x_link_placeholder' => 'Enter X link',
    'youtube_link' => 'YouTube Link',
    'youtube_link_placeholder' => 'Enter YouTube link',
    'shipping_feature_section' => 'Shipping Feature Section',
    'shipping_feature_section_placeholder' => 'Enter shipping feature section',
    'shipping_feature_section_title' => 'Shipping Feature Section Title',
    'shipping_feature_section_title_placeholder' => 'Enter shipping feature section title',
    'shipping_feature_section_description' => 'Shipping Feature Section Description',
    'shipping_feature_section_description_placeholder' => 'Enter shipping feature section description',
    'return_feature_section' => 'Return Feature Section',
    'return_feature_section_placeholder' => 'Enter return feature section',
    'return_feature_section_title' => 'Return Feature Section Title',
    'return_feature_section_title_placeholder' => 'Enter return feature section title',
    'return_feature_section_description' => 'Return Feature Section Description',
    'return_feature_section_description_placeholder' => 'Enter return feature section description',
    'safety_security_feature_section' => 'Safety & Security Feature Section',
    'safety_security_feature_section_placeholder' => 'Enter safety & security feature section',
    'safety_security_feature_section_title' => 'Safety & Security Feature Section Title',
    'safety_security_feature_section_title_placeholder' => 'Enter safety & security feature section title',
    'safety_security_feature_section_description' => 'Safety & Security Feature Section Description',
    'safety_security_feature_section_description_placeholder' => 'Enter safety & security feature section description',
    'support_feature_section' => 'Support Feature Section',
    'support_feature_section_placeholder' => 'Enter support feature section',
    'support_feature_section_title' => 'Support Feature Section Title',
    'support_feature_section_title_placeholder' => 'Enter support feature section title',
    'support_feature_section_description' => 'Support Feature Section Description',
    'support_feature_section_description_placeholder' => 'Enter support feature section description',
    'meta_keywords' => 'Meta Keywords',
    'meta_keywords_placeholder' => 'Enter meta keywords',
    'meta_description' => 'Meta Description',
    'meta_description_placeholder' => 'Enter meta description',

    // Policy Settings Labels
    'policy_settings' => 'Policy Settings',
    'return_refund_policy' => 'Return & Refund Policy',
    'return_refund_policy_placeholder' => 'Enter return and refund policy details',
    'shipping_policy' => 'Shipping Policy',
    'shipping_policy_placeholder' => 'Enter shipping policy details',
    'privacy_policy' => 'Privacy Policy',
    'privacy_policy_placeholder' => 'Enter privacy policy details',
    'terms_condition' => 'Terms & Conditions',
    'terms_condition_placeholder' => 'Enter terms and conditions details',
    'about_us_placeholder' => 'Enter about us details',

    // Delivery Boy Settings Labels
    'delivery_boy_settings' => 'Delivery Boy Settings',
    'delivery_boy_policies' => 'Delivery Boy Policies',
    'delivery_boy_terms_condition' => 'Terms & Conditions',
    'delivery_boy_terms_condition_placeholder' => 'Enter delivery boy terms and conditions',
    'delivery_boy_privacy_policy' => 'Privacy Policy',
    'delivery_boy_privacy_policy_placeholder' => 'Enter delivery boy privacy policy',
    'delivery_boy_section' => [
        'title' => 'Delivery Boy Settings',
        'description' => 'Manage delivery boy terms and conditions and privacy policy settings'
    ],

    // New App Settings Labels
    'app_settings' => 'App Settings',
    'appstore_link' => 'App Store Link',
    'appstore_link_placeholder' => 'Enter App Store link',
    'playstore_link' => 'Play Store Link',
    'playstore_link_placeholder' => 'Enter Play Store link',
    'app_scheme' => 'App Scheme',
    'app_scheme_placeholder' => 'Enter app scheme (e.g., myapp://)',
    'app_domain_name' => 'App Domain Name',
    'app_domain_name_placeholder' => 'Enter app domain name',
    // storage Settings Labels
    'storage_settings' => 'Storage Settings',
    'aws_s3' => 'AWS S3',
    'aws_access_key_id' => 'AWS Access Key ID',
    'aws_access_key_id_placeholder' => 'Enter AWS Access Key ID',
    'aws_secret_access_key' => 'AWS Secret Access Key',
    'aws_secret_access_key_placeholder' => 'Enter AWS Secret Access Key',
    'aws_region' => 'AWS Region',
    'aws_region_placeholder' => 'Enter AWS Region (e.g., us-east-1)',
    'aws_bucket' => 'AWS Bucket',
    'aws_bucket_placeholder' => 'Enter AWS Bucket name',
    'aws_asset_url' => 'AWS Asset URL',
    'aws_asset_url_placeholder' => 'Enter AWS Asset URL',
    // email settings
    'email_settings' => 'Email Settings',
    'smtp' => 'SMTP',
    'smtp_host' => 'SMTP Host',
    'smtp_host_placeholder' => 'Enter SMTP host (e.g., smtp.gmail.com)',
    'smtp_port' => 'SMTP Port',
    'smtp_port_placeholder' => 'Enter SMTP port (e.g., 587)',
    'smtp_email' => 'SMTP Email',
    'smtp_email_placeholder' => 'Enter SMTP email',
    'smtp_password' => 'SMTP Password',
    'smtp_password_placeholder' => 'Enter SMTP password',
    'smtp_encryption' => 'SMTP Encryption',
    'smtp_encryption_placeholder' => 'Select encryption type',
    'smtp_content_type' => 'SMTP Content Type',
    'smtp_content_type_placeholder' => 'Select content type',
    //payment setting
    'payment_settings' => 'Payment Settings',
    'stripe_payment' => 'Stripe Payment',
    'enable_stripe_payment' => 'Enable Stripe Payment',
    'stripe_payment_mode' => 'Stripe Payment Mode',
    'stripe_payment_mode_placeholder' => 'Select payment mode',
    'stripe_publishable_key' => 'Stripe Publishable Key',
    'stripe_publishable_key_placeholder' => 'Enter Stripe publishable key',
    'stripe_secret_key' => 'Stripe Secret Key',
    'stripe_secret_key_placeholder' => 'Enter Stripe secret key',
    'stripe_payment_endpoint_url' => 'Stripe Payment Endpoint URL',
    'stripe_payment_endpoint_url_placeholder' => 'Enter Stripe payment endpoint URL',
    'stripe_webhook_secret_key' => 'Stripe Webhook Secret Key',
    'stripe_webhook_secret_key_placeholder' => 'Enter Stripe webhook secret key',
    'stripe_currency_code' => 'Stripe Currency Code',
    'stripe_currency_code_placeholder' => 'Select currency code',
    'cash_on_delivery' => 'Cash on Delivery',
    'enable_cash_on_delivery' => 'Enable Cash on Delivery',
    'bank_details' => 'Bank Details',
    'direct_bank_transfer' => 'Direct Bank Transfer',
    'enable_direct_bank_transfer' => 'Enable Direct Bank Transfer',
    'bank_account_name' => 'Bank Account Name',
    'bank_account_name_placeholder' => 'Enter bank account name',
    'bank_account_number' => 'Bank Account Number',
    'bank_account_number_placeholder' => 'Enter bank account number',
    'bank_name' => 'Bank Name',
    'bank_name_placeholder' => 'Enter bank name',
    'bank_code' => 'Bank Code',
    'bank_code_placeholder' => 'Enter bank code (e.g., IFSC, SWIFT)',
    'bank_extra_note' => 'Bank Extra Note',
    'bank_extra_note_placeholder' => 'Enter any additional bank transfer notes',
    // notification settings
    'notification_settings' => 'Notification Settings',
    'firebase_project_id' => 'Firebase Project ID',
    'firebase_project_id_placeholder' => 'Enter Firebase Project ID',
    'service_account_file' => 'Service Account File',
    'service_account_file_placeholder' => 'Upload Firebase service account JSON file',
    'vap_id_key' => 'VAPID Key',
    'vap_id_key_placeholder' => 'Enter VAPID key',
    // auth settings
    'authentication_settings' => 'Authentication Settings',
    'enable_custom_sms' => 'Enable Custom SMS',
    'enable_firebase' => 'Enable Firebase',
    'custom_sms' => 'Custom SMS',
    'custom_sms_url' => 'Custom SMS URL',
    'custom_sms_url_placeholder' => 'Enter custom SMS URL',
    'custom_sms_method' => 'Custom SMS Method',
    'custom_sms_method_placeholder' => 'Select HTTP method',
    'custom_sms_token_account_sid' => 'Custom SMS Token Account SID',
    'custom_sms_token_account_sid_placeholder' => 'Enter token account SID',
    'custom_sms_auth_token' => 'Custom SMS Auth Token',
    'custom_sms_auth_token_placeholder' => 'Enter auth token',
    'custom_sms_text_format_data' => 'Custom SMS Text Format Data',
    'custom_sms_text_format_data_placeholder' => 'Enter text format data',
    'custom_sms_header' => 'Custom SMS Header',
    'custom_sms_header_key_placeholder' => 'Enter header key',
    'custom_sms_header_value_placeholder' => 'Enter header value',
    'custom_sms_params' => 'Custom SMS Parameters',
    'custom_sms_params_key_placeholder' => 'Enter parameter key',
    'custom_sms_params_value_placeholder' => 'Enter parameter value',
    'custom_sms_body' => 'Custom SMS Body',
    'custom_sms_body_key_placeholder' => 'Enter body key',
    'custom_sms_body_value_placeholder' => 'Enter body value',
    'add_header' => 'Add Header',
    'add_param' => 'Add Parameter',
    'add_body' => 'Add Body',
    'remove' => 'Remove',
    'google_recaptcha' => 'Google reCAPTCHA',
    'google_recaptcha_site_key' => 'Google reCAPTCHA Site Key',
    'google_recaptcha_site_key_placeholder' => 'Enter reCAPTCHA site key',
    'firebase' => 'Firebase',
    'firebase_api_key' => 'Firebase API Key',
    'firebase_api_key_placeholder' => 'Enter Firebase API key',
    'firebase_auth_domain' => 'Firebase Auth Domain',
    'firebase_auth_domain_placeholder' => 'Enter Firebase auth domain',
    'firebase_database_url' => 'Firebase Database URL',
    'firebase_database_url_placeholder' => 'Enter Firebase database URL',
    'firebase_storage_bucket' => 'Firebase Storage Bucket',
    'firebase_storage_bucket_placeholder' => 'Enter Firebase storage bucket',
    'firebase_messaging_sender_id' => 'Firebase Messaging Sender ID',
    'firebase_messaging_sender_id_placeholder' => 'Enter Firebase messaging sender ID',
    'firebase_app_id' => 'Firebase App ID',
    'firebase_app_id_placeholder' => 'Enter Firebase app ID',
    'firebase_measurement_id' => 'Firebase Measurement ID',
    'firebase_measurement_id_placeholder' => 'Enter Firebase measurement ID',
    'social_login' => 'Social Login',
    'apple_login' => 'Enable Apple Login',
    'google_login' => 'Enable Google Login',
    'facebook_login' => 'Enable Facebook Login',
    // all settings
    'system' => [
        'title' => 'System Settings',
        'description' => 'Configure core system settings and preferences.',
    ],
    'web' => [
        'title' => 'Web Settings',
        'description' => 'Manage web-specific settings for your platform.',
    ],
    'app' => [
        'title' => 'App Settings',
        'description' => 'Set up mobile app and Download Link.',
    ],
    'storage' => [
        'title' => 'Storage Settings',
        'description' => 'Oversee storage options and data management.',
    ],
    'authentication' => [
        'title' => 'Authentication Settings',
        'description' => 'Control authentication methods and security settings.',
    ],
    'payment' => [
        'title' => 'Payments Settings',
        'description' => 'Set up and manage payment methods and gateways.',
    ],
    'notification' => [
        'title' => 'Notifications Settings',
        'description' => 'Manage notification preferences and settings.',
    ],
    'email_title' => 'Email Settings',
    'email_description' => 'Configure email settings and SMTP details.',
    'email' => 'Email',
    // brand page
    'brands' => 'Brands',
    'add_brand' => 'Add Brand',
    'id' => 'ID',
    'title' => 'Title',
    'image' => 'Image',
    'status' => 'Status',
    'created_at' => 'Created At',
    'action' => 'Action',
    'create_brand' => 'Create Brand',
    'brand_name' => 'Brand Name',
    'enter_brand_name' => 'Enter brand name',
    'description' => 'Description',
    'enter_description' => 'Enter description',
    'cancel' => 'Cancel',
    'create_new_brand' => 'Create new Brand',

    // categories.blade.php
    'categories' => 'Categories',
    'add_category' => 'Add Category',
    'parent' => 'Parent',
    'create_category' => 'Create Category',
    'category_name' => 'Category Name',
    'enter_category_name' => 'Enter category name',
    'parent_category' => 'Parent Category',
    'banner' => 'Banner',
    'requires_approval' => 'Requires Approval',
    'create_new_category' => 'Create new Category',
    'commission' => 'Commission',
    'commission_placeholder' => 'Enter commission percentage',

    // BrandController messages
    'brand_created_successfully' => 'Brand created successfully',
    'brand_retrieved_successfully' => 'Brand retrieved successfully',
    'brand_updated_successfully' => 'Brand updated successfully',
    'brand_deleted_successfully' => 'Brand deleted successfully',
    'brand_not_found' => 'Brand not found',
    'validation_failed' => 'Validation failed',

    // New keys for CategoryController messages
    'category_created_successfully' => 'Category created successfully',
    'category_retrieved_successfully' => 'Category retrieved successfully',
    'category_updated_successfully' => 'Category updated successfully',
    'category_deleted_successfully' => 'Category deleted successfully',
    'category_not_found' => 'Category not found',

    // Home General Settings Labels
    'home_general_settings' => 'Home General Settings',
    'category_title' => 'Category Title',
    'enter_category_title' => 'Enter category title',
    'category_title_help' => 'This will be used as the default title for all categories configuration',
    'appearance' => 'Appearance',
    'background_type_help' => 'Choose how the background should be displayed',
    'background_color_help' => 'Select the background color for categories',
    'font_color_help' => 'Select the font color for category text',
    'home_general_settings_description' => 'Configure general settings for the home page, including Global Scope titles and appearance options.',

    'global_scope_config_note' => 'To configure global scope for categories, please visit the home page settings.',
    'setting_variables_fetched_successfully' => 'Setting variables fetched successfully',

    // Promos
    'promos' => 'Promos',
    'add_promo' => 'Add Promo',
    'create_promo' => 'Create Promo',
    'create_new_promo' => 'Create New Promo',
    'promo_code' => 'Promo Code',
    'enter_promo_code' => 'Enter promo code',
    'discount_type' => 'Discount Type',
    'select_discount_type' => 'Select discount type',
    'discount_amount' => 'Discount Amount',
    'discount_amount_or_percent' => 'Discount Amount / Percent',
    'enter_discount_amount' => 'Enter discount amount',
    'max_discount_value' => 'Max Discount Value',
    'enter_max_discount_value' => 'Enter maximum discount value',
    'required_for_percentage_discount' => 'Required for percentage discounts',
    'start_date' => 'Start Date',
    'end_date' => 'End Date',
    'min_order_total' => 'Minimum Order Total',
    'enter_min_order_total' => 'Enter minimum order total',
    'promo_mode' => 'Promo Mode',
    'enter_promo_mode' => 'Enter promo mode',
    'max_total_usage' => 'Max Total Usage',
    'enter_max_total_usage' => 'Enter maximum total usage',
    'max_usage_per_user' => 'Max Usage Per User',
    'enter_max_usage_per_user' => 'Enter maximum usage per user',
    'individual_use' => 'Individual Use',
    'individual_use_help' => 'Cannot be used with other promos',
    'usage_count' => 'Usage Count',
    'max_usage' => 'Max Usage',
    'promo_details' => 'Promo Details',
    'fixed_amount' => 'Fixed Amount',

    // PromoController messages
    'promo_created_successfully' => 'Promo created successfully',
    'promo_retrieved_successfully' => 'Promo retrieved successfully',
    'promo_updated_successfully' => 'Promo updated successfully',
    'promo_deleted_successfully' => 'Promo deleted successfully',
    'promo_not_found' => 'Promo not found',

    // Commission Settlement
    'commission_settlements' => 'Commission Settlements',
    'credits' => 'Credits',
    'debits' => 'Debits',
    'settle_all_debits' => 'Settle All Debits',
    'unsettled_commissions' => 'Unsettled Commissions',
    'settle_all_commissions' => 'Settle All Commissions',
    'confirm_settlement' => 'Confirm Settlement',
    'confirm_settlement_message' => 'Are you sure you want to settle this commission?',
    'settle_all_commissions_message' => 'Are you sure you want to settle all unsettled commissions?',
    'commission_settled_successfully' => 'Commission settled successfully',
    'all_commissions_settled_successfully' => 'All commissions settled successfully',
    'commissions_settled_with_errors' => 'Some commissions were settled with errors',
    'commission_amount' => 'Commission Amount',
    'settlement_history' => 'Settlement History',
    'back_to_unsettled' => 'Back to Unsettled',
    'admin_commission' => 'Admin Commission',
    'seller_commission' => 'Seller Commission',
    'settlement_date' => 'Settlement Date',
    'order_current_status' => 'Order Current Status',
    'order_item_id' => 'Order Item ID',
    'marketplace_fee' => 'Marketplace Fee',
    'payout_amount' => 'Payout Amount',
    'details' => 'Details',
    'entry_type' => 'Entry Type',
    'debit_amount' => 'Debit Amount',
    'return_id' => 'Return ID',
    "reference_type" => "Reference Type",
    'reference_id' => 'Reference ID',

    // New keys for AuthTrait messages
    'invalid_credentials' => 'Invalid credentials',
    'login_successful' => 'Login successful',
    'login_failed' => 'Login failed: :error',
    'registration_successful' => 'Registration successful',
    'registration_failed' => 'Registration failed: :error',
    'logged_out_successfully' => 'Logged out successfully',
    'password_reset_failed' => 'Password reset failed: :error',

    // New keys for SettingController messages
    'invalid_type' => 'Invalid type',
    'setting_updated_successfully' => ':type Setting updated successfully',
    'setting_created_successfully' => ':type Setting created successfully',
    'setting_operation_failed' => 'Setting operation failed: :error',

    // sellers
    'sellers' => 'Sellers',
    'seller' => 'Seller',
    'mobile' => 'Mobile',
    'verification_status' => 'Verification Status',
    'visibility_status' => 'Visibility Status',
    'user_not_found' => 'User not found',
    'seller_already_exists' => 'Seller already exists',
    'seller_created_successfully' => 'Seller created successfully',
    'user_creation_failed' => 'User creation failed',
    'seller_not_found' => 'Seller not found.',
    'seller_updated_successfully' => 'Seller updated successfully',
    'seller_deleted_successfully' => 'Seller deleted successfully',
    'error_occurred' => 'An error occurred: :error',
    // New keys for form.blade.php
    'edit_seller' => 'Edit Seller',
    'add_seller' => 'Add Seller',
    'basic_details' => 'Basic Details',
    'location_details' => 'Location Details',
    'business_documents' => 'Business Documents',
    'status_and_metadata' => 'Status and Metadata',
    'seller_name' => 'Seller Name',
    'store_name' => 'Store Name',
    'enter_store_name' => 'Enter Store name',
    'country' => 'Country',
    'enter_mobile_number' => 'Enter mobile number',
    'enter_email_address' => 'Enter email address',
    'password' => 'Password',
    'enter_password' => 'Enter password',
    'enter_address' => 'Enter address',
    'city' => 'City',
    'enter_city' => 'Enter city',
    'landmark' => 'Landmark',
    'enter_landmark' => 'Enter landmark',
    'state' => 'State',
    'enter_state' => 'Enter state',
    'zipcode' => 'Zipcode',
    'enter_zipcode' => 'Enter zipcode',
    'business_license' => 'Business License',
    'articles_of_incorporation' => 'Articles of Incorporation',
    'national_identity_card' => 'National Identity Card',
    'authorized_signature' => 'Authorized Signature',
    'approved' => 'Approved',
    'not_approved' => 'Not Approved',
    'metadata' => 'Metadata',
    'enter_metadata_json' => 'Enter metadata (JSON format)',
    'visible' => 'Visible',
    'draft' => 'Draft',
    'seller_not_verified' => 'Seller not verified! Please Try Again Later.',
    // Permission / Validation Labels
    'permission_denied' => 'You do not have permission to perform this action.',

    // Tax Group Labels
    'tax_class_created_successfully' => 'Tax Group created successfully.',
    'tax_class_not_found' => 'Tax Group not found.',
    'tax_class_fetched_successfully' => 'Tax Group fetched successfully.',
    'tax_class_updated_successfully' => 'Tax Group updated successfully.',
    'tax_class_deleted_successfully' => 'Tax Group deleted successfully.',

    // Tax Rate Labels
    'tax_rate_created_successfully' => 'Tax rate created successfully.',
    'tax_rate_not_found' => 'Tax rate not found.',
    'tax_rate_fetched_successfully' => 'Tax rate fetched successfully.',
    'tax_rate_updated_successfully' => 'Tax rate updated successfully.',
    'tax_rate_deleted_successfully' => 'Tax rate deleted successfully.',
    'tax_rate_create_failed' => 'Failed to create Tax Rate.',
    'tax_rate_update_failed' => 'Failed to update Tax Rate.',
    'tax_rate_delete_failed' => 'Failed to delete Tax Rate.',
    'rates' => 'Rates',
    'rate' => 'Rate',

    // role
    'role_created_successfully' => 'Role created successfully.',
    'role_not_found' => 'Role not found.',
    'role_retrieved_successfully' => 'Role retrieved successfully.',
    'role_updated_successfully' => 'Role updated successfully.',
    'role_deleted_successfully' => 'Role deleted successfully.',
    'cannot_modify_role' => 'You cannot modify this role.',
    'cannot_delete_role' => 'You cannot delete this role.',
    'name' => 'Name',
    'guard_name' => 'Guard Name',
    'permissions' => 'Permissions',

    // stores
    'operational_settings' => 'Operational Settings',
    'policies' => 'Policies',
    'store_url' => 'Store URL',
    'enter_store_url' => 'Enter store URL',
    'about_us' => 'About Us',
    'enter_about_us' => 'Enter about us',
    'contact_email' => 'Contact Email',
    'contact_number' => 'Contact Number',
    'select_country' => 'Select country',
    'country_code' => 'Country Code',
    'enter_country_code' => 'Enter country code (e.g., +1)',
    'latitude' => 'Latitude',
    'enter_latitude' => 'Enter latitude',
    'longitude' => 'Longitude',
    'enter_longitude' => 'Enter longitude',
    'address_proof' => 'Address Proof',
    'voided_check' => 'Voided Check',
    'tax_name' => 'Tax Name',
    'enter_tax_name' => 'Enter tax name',
    'tax_number' => 'Tax Number',
    'enter_tax_number' => 'Enter tax number',
    'enter_bank_name' => 'Enter bank name',
    'bank_branch_code' => 'Bank Branch Code',
    'enter_bank_branch_code' => 'Enter bank branch code',
    'account_holder_name' => 'Account Holder Name',
    'enter_account_holder_name' => 'Enter account holder name',
    'account_number' => 'Account Number',
    'enter_account_number' => 'Enter account number',
    'routing_number' => 'Routing Number',
    'enter_routing_number' => 'Enter routing number',
    'bank_account_type' => 'Bank Account Type',
    'enter_bank_account_type' => 'Enter bank account type',
    'currency_code' => 'Currency Code',
    'enter_currency_code' => 'Enter currency code (e.g., USD)',
    'timing' => 'Timing',
    'enter_timing' => 'Enter timing (e.g., Mon-Fri 9AM-5PM)',
    'store_status' => 'Store Status',
    'online' => 'Online',
    'offline' => 'Offline',
    'store_status_help' => 'Select whether the store is available for orders or not',
    'max_delivery_distance' => 'Max Delivery Distance',
    'enter_max_delivery_distance' => 'Enter max delivery distance (in km)',
    'shipping_min_free_delivery_amount' => 'Minimum Free Delivery Amount',
    'enter_shipping_min_free_delivery_amount' => 'Enter minimum amount for free delivery',
    'shipping_charge_priority' => 'Shipping Charge Priority',
    'enter_shipping_charge_priority' => 'Enter shipping charge priority',
    'allowed_order_per_time_slot' => 'Allowed Orders Per Time Slot',
    'enter_allowed_order_per_time_slot' => 'Enter allowed orders per time slot',
    'order_preparation_time' => 'Order Preparation Time',
    'enter_order_preparation_time' => 'Enter order preparation time (in minutes)',
    'carrier_partner' => 'Carrier Partner',
    'enter_carrier_partner' => 'Enter carrier partner',
    'shipping_preference' => 'Shipping Preference',
    'enter_shipping_preference' => 'Enter shipping preference',
    'domestic_shipping_charges' => 'Domestic Shipping Charges',
    'enter_domestic_shipping_charges' => 'Enter domestic shipping charges',
    'international_shipping_charges' => 'International Shipping Charges',
    'enter_international_shipping_charges' => 'Enter international shipping charges',
    'fulfillment_type' => 'Fulfillment Type',
    'enter_fulfillment_type' => 'Enter fulfillment type',
    'promotional_text' => 'Promotional Text',
    'enter_promotional_text' => 'Enter promotional text',
    'return_replacement_policy' => 'Return/Replacement Policy',
    'enter_return_replacement_policy' => 'Enter return/replacement policy',
    'refund_policy' => 'Refund Policy',
    'enter_refund_policy' => 'Enter refund policy',
    'terms_and_conditions' => 'Terms and Conditions',
    'enter_terms_and_conditions' => 'Enter terms and conditions',
    'delivery_policy' => 'Delivery Policy',
    'enter_delivery_policy' => 'Enter delivery policy',
    'firebase_config_fetched_successfully' => 'Firebase config fetched successfully',
    'enter_permissions' => 'Enter permissions',
    'enter_metadata' => 'Enter metadata',
    'select_verification_status' => 'Select verification status',
    'pending' => 'Pending',
    'verified' => 'Verified',
    'rejected' => 'Rejected',
    'select_visibility_status' => 'Select visibility status',
    'hidden' => 'Hidden',
    'monday' => 'Monday',
    'tuesday' => 'Tuesday',
    'wednesday' => 'Wednesday',
    'thursday' => 'Thursday',
    'friday' => 'Friday',
    'saturday' => 'Saturday',
    'sunday' => 'Sunday',
    'home' => 'Home',
    'list' => "List",
    'settings' => 'Settings',
    'setting' => 'Setting',
    'admin' => 'Admin',
    'stores' => 'Stores',
    'store' => 'Store',
    'enter_seller_name' => 'Enter Seller Name',
    'search_by_seller' => 'Filter by Seller',
    'filter_by_verification_status' => 'Filter by Verification Status',
    'filter_by_visibility_status' => 'Filter by Visibility Status',
    'select_status' => 'Select Status',
    'actions' => 'Actions',
    'about' => 'About',
    'delivery_zone_id' => 'Delivery Zone ID',
    'contact_information' => 'Contact Information',
    'operational_timing' => 'Operational & Timing',
    'financial_bank_details' => 'Financial & Bank Details',
    'shipping_delivery' => 'Shipping & Delivery',
    'verify_account' => 'Verify Account',
    'products' => 'Products',
    'product' => 'Product',
    'add_product' => 'Add Product',
    'back_to_attributes' => 'Back to Attributes',
    'add_attributes' => 'Add Attributes',
    'add_attribute' => 'Add Attribute',
    'attribute_name' => 'Attribute Name',
    'swatch_type' => 'Swatch type',
    'text' => 'Text',
    'attribute_values' => 'Attribute Values',
    'swatch_value' => 'Swatch Value',
    'add_value' => 'Add Value',
    'save_attribute' => 'Save Attribute',
    'eg_red' => 'e.g., red',
    'automatically_set_based_on_attribute' => 'This is automatically set based on the attribute.',
    'enter_swatche_value' => 'Enter swatche value',
    'add_more_values' => 'Add More Values',
    'create_new_attribute_value' => 'Create new Attribute Value',
    'attributes' => 'Attributes',
    'create_attribute' => 'Create Attribute',
    'create_attribute_value' => 'Create Attribute Value',
    'create_new_attribute' => 'Create new Attribute',
    'label' => 'Label',
    'swatche_type' => 'Swatch Type',
    'select_type' => 'Select Type',
    'selectAttribute' => 'Select Attribute',
    'value' => 'Value',
    'swatcheValue' => 'Swatch Value',
    'global_attribute_id' => 'Global Attribute ID',
    'attribute_title' => 'Attribute Title',
    'swatche_value' => 'Swatche Value',

    // Product Conditions
    'product_conditions' => 'Product Conditions',
    'product_condition' => 'Product Condition',
    'add_product_condition' => 'Add Product Condition',
    'edit_product_condition' => 'Edit Product Condition',
    'create' => 'Create',
    'update' => 'Update',
    'alignment' => 'Alignment',
    'strip' => 'Strip',
    'select_category' => 'Select Category',
    'category' => 'Category',

    // product
    'product_title' => 'Product Title',
    'brand' => 'Brand',
    'select_brand' => 'Select Brand',
    'indicator' => 'Indicator',
    'select_indicator' => 'Select Indicator',
    'featured_product' => 'Featured Product',
    'product_type' => 'Product Type',
    'main_image' => 'Main Image',
    'additional_images' => 'Additional Images',
    'select_video_type' => 'Select Video Type',
    'video_upload' => 'Video Upload',
    'select_tags' => 'Select Tags',
    'price' => 'Price',
    'special_price' => 'Special Price',
    'cost' => 'Cost',
    'stock' => 'Stock',
    'policies_and_features' => 'Policies and Features',
    'variations' => 'Variations',
    'images' => 'Images',
    'required' => 'Required',
    'not_required' => 'Not Required',
    'admin_approval_status' => 'Admin Approval Status',
    'pricing' => 'Pricing',
    'validation_error' => 'Validation Error',
    'account_deleted_successfully' => 'Account Deleted Successfully',
    'tax_class' => 'Tax Group',
    'tax_rate' => 'Tax Rate',
    'custom_url' => 'Custom URL',
    'tax_group' => 'Tax Group',
    'pricing_and_taxes' => 'Pricing & Taxes',
    'create_product' => 'Create Product',
    'back_to_products' => 'Back to Products',
    'setting_fetched_successfully' => 'Setting Fetched Successfully',
    'user_not_authenticated' => 'User not authenticated',
    'profile_updated_successfully' => 'Profile updated successfully',
    'profile_retrieved_successfully' => 'Profile retrieved successfully',
    'wallet_retrieved_successfully' => 'Wallet retrieved successfully',
    'wallet_not_found' => 'Wallet not found',
    'wallet_balance_added_successfully' => 'Wallet balance added successfully',
    'wallet_balance_deducted_successfully' => 'Wallet balance deducted successfully',
    'insufficient_wallet_balance' => 'Insufficient wallet balance',
    'wallet_transactions_retrieved_successfully' => 'Wallet transactions retrieved successfully',
    'wallet_transaction_retrieved_successfully' => 'Wallet transaction retrieved successfully',
    'transaction_retrieved_successfully' => 'Transaction retrieved successfully',
    'wallet_transaction_not_found' => 'Wallet transaction not found',
    'transaction_not_found' => 'Transaction not found',

// Banner-specific labels
    'banners' => 'Banners',
    'create_banner' => 'Create Banner',
    'edit_banner' => 'Edit Banner',
    'update_banner' => 'Update Banner',
    'delete_banner' => 'Delete Banner',
    'banner_information' => 'Banner Information',
    'banners_list' => 'Banners List',
    'banner_image' => 'Banner Image',
    'banner_not_found' => 'Banner not found',
    'banner_created_successfully' => 'Banner created successfully',
    'banner_updated_successfully' => 'Banner updated successfully',
    'banner_deleted_successfully' => 'Banner deleted successfully',
    'banner_saved_successfully' => 'Banner saved successfully',
    'failed_to_delete_banner' => 'Failed to delete banner',
    'banner_retrieved_successfully' => 'Banner retrieved successfully',

    // Banner form fields
    'enter_banner_title' => 'Enter banner title',
    'enter_banner_slug' => 'Enter banner slug',
    'select_banner_type' => 'Select banner type',
    'select_banner_position' => 'Select banner position',
    'enter_action_url' => 'Enter action URL',
    'enter_display_order' => 'Enter display order',
    'scope_type' => 'Scope Type',
    'select_scope_type' => 'Select scope type',
    'all_scopes' => 'All Scopes',

    // Banner types and positions
    'type' => 'Type',
    'position' => 'Position',
    'action_url' => 'Action URL',
    'display_order' => 'Display Order',

    // Filter labels
    'all_types' => 'All Types',
    'all_positions' => 'All Positions',
    'all_status' => 'All Status',

    // Status labels
    'published' => 'Published',

    // Dropdown selections
    'select_product' => 'Select Product',

    // Form actions
    'back_to_list' => 'Back to List',
    'processing' => 'Processing',

    // General labels used in forms
    'slug' => 'Slug',
    'management' => 'Management',

    // DataTable labels
    'search' => 'Search',
    'show' => 'Show',
    'entries' => 'entries',
    'showing' => 'Showing',
    'to' => 'to',
    'of' => 'of',
    'no_matching_records_found' => 'No matching records found',
    'no_data_available_in_table' => 'No data available in table',
    'first' => 'First',
    'last' => 'Last',
    'next' => 'Next',
    'previous' => 'Previous',

    // Common action labels
    'updated_at' => 'Updated At',

    // Alert/confirmation labels
    'are_you_sure' => 'Are you sure?',
    'you_wont_be_able_to_revert_this' => 'You won\'t be able to revert this!',
    'yes_delete_it' => 'Yes, delete it!',
    'deleted' => 'Deleted!',
    'error' => 'Error!',
    'something_went_wrong' => 'Something went wrong!',
    'banner_fetched_successfully' => 'Banner fetched successfully',
    'category_fetched_successfully' => 'Category fetched successfully',
    'brand_fetched_successfully' => 'Brand fetched successfully',

    // Delivery Zone labels
    'delivery_zones' => 'Delivery Zones',
    'add_delivery_zone' => 'Add Delivery Zone',
    'edit_delivery_zone' => 'Edit Delivery Zone',
    'delete_delivery_zone' => 'Delete Delivery Zone',
    'delivery_zone_name' => 'Delivery Zone Name',
    'delivery_zone_list' => 'Delivery Zone List',
    'delivery_zone_information' => 'Delivery Zone Information',
    'delivery_zone_created_successfully' => 'Delivery Zone created successfully',
    'delivery_zone_updated_successfully' => 'Delivery Zone updated successfully',
    'delivery_zone_deleted_successfully' => 'Delivery Zone deleted successfully',
    'delivery_zone_not_found' => 'Delivery Zone not found',
    'enter_delivery_zone_name' => 'Enter delivery zone name',
    'select_delivery_zone' => 'Select Delivery Zone',
    'location_not_in_delivery_zone' => 'Your location is not within the delivery zone',
    'google_api_key' => 'Google API Key',
    'enter_google_api_key' => 'Enter Google API Key',
    'google_keys' => 'Google Keys',
    'select_delivery_zones' => 'Select Delivery Zones',
    'zone_name' => 'Zone Name',
    'search_for_city' => 'Search for a city',
    'remove_polygon' => 'Remove Polygon',
    'save' => 'Save',
    'placeholder_zone_name' => 'e.g. Mumbai Central',
    'center_latitude' => 'Center Latitude',
    'center_longitude' => 'Center Longitude',
    'radius_km' => 'Radius (KM)',
    'boundary_json' => 'Boundary Data',
    'error_delivery_zone' => 'Error creating delivery zone',
    'delivery_zone' => 'Delivery Zone',
    'create_delivery_zone' => 'Create Delivery Zone',
    'delivery_zones_list' => 'Delivery Zones List',
    'boundary_json_invalid' => 'Invalid boundary JSON format',
    'delivery_available' => 'Delivery is available at this location',
    'delivery_not_available' => 'Delivery is not available at this location',
    'items_not_deliverable_to_address' => 'Some items in your cart are not deliverable to the selected address',
    'stores_fetched_successfully' => 'Stores fetched successfully',
    'no_delivery_zone_found' => 'No delivery zones found for this location',
    'product_fetched_successfully' => 'Product Fetched Successfully',
    'products_fetched_successfully' => 'Products Fetched Successfully',
    'delivery_time_per_km' => 'Delivery Time Per KM',
    'buffer_time' => 'Buffer Time',
    'product_updated_successfully' => 'Product updated successfully',
    'product_created_successfully' => 'Product created successfully',
    'product_deleted_successfully' => 'Product deleted successfully',
    'product_not_found' => 'Product not found',
    'products_not_found' => 'No Products found',
    'error_fetching_products' => 'Error fetching products',
    'error_fetching_product' => 'Error fetching product',
    'failed_to_create_product' => 'Failed to create product',
    'failed_to_fetch_product_pricing' => 'Failed to fetch product pricing',
    'failed_to_fetch_product_faqs' => 'Failed to fetch product FAQs',

    // FAQ Labels
    'faqs_fetched_successfully' => 'FAQs fetched successfully',
    'faq_fetched_successfully' => 'FAQ fetched successfully',
    'faq_not_found' => 'FAQ not found',
    'faq_created_successfully' => 'FAQ created successfully',
    'faq_updated_successfully' => 'FAQ updated successfully',
    'faq_deleted_successfully' => 'FAQ deleted successfully',
    'invalid_faq_data' => 'Invalid FAQ data provided',
    'faq_already_exists' => 'FAQ already exists',
    'no_faqs_found' => 'No FAQs found',
    'add_faq' => 'Add FAQ',
    'question' => 'Question',
    'answer' => 'Answer',
    'enter_question' => 'Enter question',
    'enter_answer' => 'Enter answer',
    // Product FAQ Labels
    'product_faqs_fetched_successfully' => 'Product FAQs fetched successfully',
    'product_faq_fetched_successfully' => 'Product FAQ fetched successfully',
    'product_faq_not_found' => 'Product FAQ not found',
    'product_faq_created_successfully' => 'Product FAQ created successfully',
    'product_faq_updated_successfully' => 'Product FAQ updated successfully',
    'product_faq_deleted_successfully' => 'Product FAQ deleted successfully',
    'invalid_product_faq_data' => 'Invalid product FAQ data provided',
    'no_product_faqs_found' => 'No product FAQs found',

    // Wishlist Labels
    'wishlists_fetched_successfully' => 'Wishlists fetched successfully',
    'wishlist_fetched_successfully' => 'Wishlist fetched successfully',
    'wishlist_not_found' => 'Wishlist not found',
    'wishlist_created_successfully' => 'Wishlist created successfully',
    'wishlist_already_exists' => 'Wishlist with this name already exists',
    'wishlist_updated_successfully' => 'Wishlist updated successfully',
    'wishlist_deleted_successfully' => 'Wishlist deleted successfully',
    'cannot_delete_default_wishlist' => 'Cannot delete default wishlist',
    'item_added_to_wishlist' => 'Item added to wishlist successfully',
    'item_removed_from_wishlist' => 'Item removed from wishlist successfully',
    'item_moved_successfully' => 'Item moved successfully',
    'item_already_in_wishlist' => 'Item already exists in this wishlist',
    'item_already_in_target_wishlist' => 'Item already exists in target wishlist',
    'wishlist_item_not_found' => 'Wishlist item not found',
    'target_wishlist_not_found' => 'Target wishlist not found',
    'wishlist_created_and_item_added' => 'Wishlist created and item added successfully',
    'featured_sections' => 'Featured Sections',
    'add_featured_section' => 'Add Featured Section',
    'create_featured_section' => 'Create Featured Section',
    'edit_featured_section' => 'Edit Featured Section',
    'featured_section_name' => 'Featured Section Name',
    'enter_featured_section_name' => 'Enter featured section name',
    'enter_slug' => 'Enter slug',
    'section_type' => 'Section Type',
    'select_section_type' => 'Select section type',
    'sort_order' => 'Sort Order',
    'enter_sort_order' => 'Enter sort order',
    'style' => 'Style',
    'enter_style' => 'Enter style (CSS class)',
    'select_categories' => 'Select categories',
    'newly_added' => 'Newly Added',
    'top_rated' => 'Top Rated',
    'trending' => 'Trending',
    'best_seller' => 'Best Seller',
    'featured' => 'Featured',
    'on_sale' => 'On Sale',
    'recommended' => 'Recommended',
    'create_new_featured_section' => 'Create new Featured Section',

    // Featured Section Controller Messages
    'featured_section_created_successfully' => 'Featured section created successfully',
    'featured_section_retrieved_successfully' => 'Featured section retrieved successfully',
    'featured_section_updated_successfully' => 'Featured section updated successfully',
    'featured_section_deleted_successfully' => 'Featured section deleted successfully',
    'featured_section_not_found' => 'Featured section not found',
    'categories_retrieved_successfully' => 'Categories retrieved successfully',
    'error_retrieving_categories' => 'Error retrieving categories',
    'unauthorized_access' => 'Unauthorized access',
    'loading' => 'Loading...',
    'no_data_available' => 'No data available in table',
    'creating' => 'Creating',
    'updating' => 'Updating',
    'success' => 'Success!',
    // Sorting labels
    'sort_featured_sections' => 'Sort Featured Sections',
    'drag_and_drop_to_reorder' => 'Drag and drop to reorder sections',
    'sorting_instructions' => 'Sorting Instructions',
    'drag_drop_instruction' => 'Drag and drop the sections below to change their display order. Click "Save Order" to apply changes.',
    'no_featured_sections_found' => 'No Featured Sections Found',
    'create_featured_sections_first' => 'Create some featured sections first to start sorting.',
    'save_order' => 'Save Order',
    'reset_order' => 'Reset Order',
    'updating_order' => 'Updating Order',
    'active' => 'Active',
    'inactive' => 'Inactive',
    'no_changes' => 'No Changes',
    'no_changes_to_save' => 'No changes have been made to save.',
    'no_changes_to_reset' => 'No changes have been made to reset.',
    'reset_order_confirmation' => 'Reset Order?',
    'reset_order_warning' => 'This will reset the order back to the original state. Are you sure?',
    'yes_reset' => 'Yes, Reset',
    'order_reset' => 'Order Reset',
    'order_reset_success' => 'Order has been reset successfully.',
    'unsaved_changes_warning' => 'You have unsaved changes. Are you sure you want to leave?',
    'sort_order_updated_successfully' => 'Sort order updated successfully',

    // Featured Sections API labels
    'featured_sections_fetched_successfully' => 'Featured sections fetched successfully',
    'featured_section_fetched_successfully' => 'Featured section fetched successfully',
    'featured_section_products_fetched_successfully' => 'Featured section products fetched successfully',
    'featured_section_types_fetched_successfully' => 'Featured section types fetched successfully',
    'admin_login' => 'Admin Login',
    'search_location' => 'Search for a location',
    'default_location' => 'Default Location',
    'latitude_placeholder' => 'Enter latitude',
    'longitude_placeholder' => 'Enter longitude',
    'country_validation' => 'Country Validation',
    'enable_country_validation' => 'Enable Country Validation',
    'allowed_countries' => 'Allowed Countries',
    'select_countries' => 'Select Countries',

    // Cart Labels
    'cart' => 'Cart',
    'cart_item' => 'Cart Item',
    'cart_items' => 'Cart Items',
    'quantity' => 'Quantity',
    'save_for_later' => 'Save for Later',
    'product_id' => 'Product ID',
    'product_variant_id' => 'Product Variant ID',
    'store_id' => 'Store ID',
    'cart_id' => 'Cart ID',

    // Location Labels
    'coordinates' => 'Coordinates',
    'location' => 'Location',
    'address_not_found' => 'Valid address is required to view cart',

    // Delivery Labels
    'delivery_time' => 'Delivery Time',
    'estimated_delivery' => 'Estimated Delivery',
    'delivery_estimate' => 'Delivery Estimate',
    'rush_delivery_not_available' => 'Rush delivery is not available in this zone',

    // Delivery Zone Fields
    'rush_delivery_enabled' => 'Rush Delivery Enabled',
    'rush_delivery_time_per_km' => 'Rush Delivery Time Per KM',
    'rush_delivery_charges' => 'Rush Delivery Charges',
    'regular_delivery_charges' => 'Regular Delivery Charges',
    'free_delivery_amount' => 'Free Delivery Amount',
    'distance_based_delivery_charges' => 'Distance Based Delivery Charges',
    'per_store_drop_off_fee' => 'Per Store Drop Off Fee',
    'handling_charges' => 'Handling Charges',

    // Delivery Boy Earnings Labels
    'base_fee' => 'Base Fee',
    'per_store_pickup_fee' => 'Per Store Pickup Fee',
    'distance_based_fee' => 'Distance-Based Fee',
    'per_order_incentive' => 'Per-Order Incentive',

    // Delivery Boy Earnings Labels
    'delivery_boy_earnings' => 'Delivery Boy Earnings',
    'pending_payments' => 'Pending Payments',
    'payment_history' => 'Payment History',
    'process_payment' => 'Process Payment',
    'confirm_payment' => 'Confirm Payment',
    'confirm_payment_message' => 'Are you sure you want to process this payment? The amount will be transferred to the delivery boy\'s wallet.',
    'payment_processed_successfully' => 'Payment processed successfully',
    'back_to_pending_payments' => 'Back to Pending Payments',
    'amount' => 'Amount',
    'paid_at' => 'Paid At',
    'transaction_id' => 'Transaction ID',
    'total_earnings' => 'Total Earnings',

    // Delivery Boy Cash Collection Labels
    'delivery_boy_cash_collections' => 'Delivery Boy Cash Collections',
    'pending_cash_collections' => 'Pending Cash Collections',
    'cash_collected' => 'Cash Collected',
    'cash_submitted' => 'Cash Submitted',
    'submission_status' => 'Submission Status',
    'process_submission' => 'Process Submission',
    'process_cash_submission' => 'Process Cash Submission',
    'confirm_cash_submission_message' => 'Are you sure you want to process this cash submission? This will update the amount of cash submitted by the delivery boy.',
    'cash_submission_processed_successfully' => 'Cash submission processed successfully',
    'back_to_pending_collections' => 'Back to Pending Collections',
    'remaining_amount' => 'Remaining Amount',
    'submission_amount' => 'Submission Amount',
    'submitted_at' => 'Submitted At',
    'cash_submission_history' => 'Cash Submission History',
    'invalid_amount' => 'Invalid amount',
    'submitted' => 'Submitted',
    'partially_submitted' => 'Partially Submitted',
    'total_cash_collected' => 'Total Cash Collected',
    'total_cash_submitted' => 'Total Cash Submitted',
    'total_remaining' => 'Total Remaining',

    // Wallet Labels
    'wallet' => 'Wallet',
    'wallet_balance' => 'Wallet Balance',
    'wallet_payment' => 'Wallet Payment',
    'use_wallet' => 'Use Wallet',

    // Authentication & authorization
    'review_not_found_or_unauthorized' => 'Review not found or you are not authorized to perform this action.',

    // General review actions
    'reviews_fetched_successfully' => 'Reviews fetched successfully.',
    'review_fetched_successfully' => 'Review fetched successfully.',
    'review_added_successfully' => 'Review has been added successfully.',
    'already_reviewed_this_product' => 'You have already submitted a review for this product.',
    'already_reviewed_this_order_item' => 'You have already submitted a review for this order item.',
    'order_item_not_delivered' => 'You can only review an item after it has been delivered.',
    'review_not_found' => 'Review not found.',
    'review_updated_successfully' => 'Review updated successfully.',
    'review_deleted_successfully' => 'Review deleted successfully.',
    'products_available_for_review_fetched_successfully' => 'Products available for review fetched successfully.',
    'not_authorized_to_modify_review' => 'You are not authorized to modify this review.',
    'model_not_found' => 'The requested model was not found.',
    'date_range' => 'Date Range',
    'invalid_date_range' => 'Invalid date range',
    'last_30_minutes' => 'Last 30 Minutes',
    'last_1_hour' => 'Last 1 Hour',
    'last_5_hours' => 'Last 5 Hours',
    'last_1_day' => 'Last 1 Day',
    'last_365_days' => 'Last 365 Days',

    // Seller Feedback Labels
    'seller_feedback_fetched_successfully' => 'Seller feedback fetched successfully.',
    'already_provided_feedback_for_this_seller' => 'You have already provided feedback for this seller.',
    'seller_feedback_added_successfully' => 'Seller feedback added successfully.',
    'seller_feedback_not_found' => 'Seller feedback not found.',
    'seller_feedback_not_found_or_unauthorized' => 'Seller feedback not found or you are not authorized to perform this action.',
    'seller_feedback_updated_successfully' => 'Seller feedback updated successfully.',
    'seller_feedback_deleted_successfully' => 'Seller feedback deleted successfully.',
    'seller_id_required' => 'Seller ID is required.',
    'seller_ratings_fetched_successfully' => 'Seller ratings fetched successfully.',
    'order_id_required_for_feedback' => 'Order ID is required to provide feedback for a seller.',
    'order_not_found_or_not_yours' => 'Order not found or does not belong to you.',
    'no_delivered_items_from_seller' => 'You can only provide feedback for orders that have been delivered by this seller.',
    'already_provided_feedback_for_this_order_item' => 'You have already provided feedback for this order item.',
    'order_item_not_from_seller' => 'The selected order item does not belong to the specified seller.',

    // Seller Order Labels
    'one_week_ago' => '1 Week Ago',
    'order_id' => 'Order ID',
    'buyer_name' => 'Buyer Name',
    'payment_method' => 'Payment Method',
    'product_name' => 'Product Name',
    'variant_name' => 'Variant Name',
    'sku' => 'SKU',
    'item_sub_total' => 'Item Sub Total',
    'edit_order' => 'Edit Order #',
    'refresh' => 'Refresh',
    'is_rush_order' => 'Is Rush Delivery',
    'orders' => 'Orders',
    'invalid_status' => 'Invalid Status',
    'order_item_not_found' => 'Order Item Not Found',
    'order_must_be_accepted_first' => 'Order must be accepted first before marking as preparing',
    'order_item_must_be_preparing_first' => 'Order item must be in preparing status before marking as collected',
    'order_item_must_be_collected_first' => 'Order item must be in collected status before marking as delivered',
    'status_already_set' => 'Status Already Set',

    // Delivery Boy Labels
    'not_a_delivery_boy' => 'User is not registered as a delivery boy',
    'account_not_verified' => 'Your account has not been verified yet',
    'account_inactive' => 'Your account is currently inactive',
    'orders_fetched_successfully' => 'Orders fetched successfully',
    'order_fetched_successfully' => 'Order fetched successfully',
    'order_not_found_or_not_available' => 'Order not found or not available for acceptance',
    'order_accepted_successfully' => 'Order accepted successfully',

    // Delivery Boy Labels
    'delivery_boys' => 'Delivery Boys',
    'delivery_boy' => 'Delivery Boy',
    'delivery_boy_details' => 'Delivery Boy Details',
    'full_name' => 'Full Name',
    'vehicle_type' => 'Vehicle Type',
    'driver_license' => 'Driver License',
    'driver_license_number' => 'Driver License Number',
    'vehicle_registration' => 'Vehicle Registration',
    'verification_remark' => 'Verification Remark',
    'optional_remark' => 'Optional remark',
    'update_verification_status' => 'Update Verification Status',
    'update_status' => 'Update Status',
    'view' => 'View',
    'edit' => 'Edit',
    'delete' => 'Delete',
    'delete_delivery_boy' => 'Delete Delivery Boy',
    'delete_delivery_boy_confirmation' => 'Are you sure you want to delete this delivery boy? This action cannot be undone.',

// Success Messages
    'delivery_boy_retrieved_successfully' => 'Delivery boy retrieved successfully',
    'verification_status_updated_successfully' => 'Verification status updated successfully',
    'status_updated_successfully' => 'Status updated successfully',
    'delivery_boy_deleted_successfully' => 'Delivery boy deleted successfully',

// Error Messages
    'delivery_boy_not_found' => 'Delivery boy not found',
    'error_fetching_dashboard_data' => 'Error fetching dashboard data',

    'personal_information' => 'Personal Information',
    'delivery_information' => 'Delivery Information',
    'verification_details' => 'Verification Details',
    'documents' => 'Documents',
    'registration_date' => 'Registration Date',
    'completed_orders' => 'Completed Orders',
    'rating' => 'Rating',
    'no_rating' => 'No Rating',
    'view_full_image' => 'View Full Image',
    'no_document_uploaded' => 'No document uploaded',
    'order_status' => 'Order Status',
    'delivery_changes_and_details' => 'Delivery Changes and Details',
    'payment_status' => 'Payment Status',
    'confirmed' => 'Confirmed',
    'confirm' => 'Confirm',
    'submission_history' => 'Submission History',

    // Delivery Boy Withdrawal Labels
    'request_withdrawal' => 'Request Withdrawal',
    'withdrawal_amount' => 'Withdrawal Amount',
    'request_note' => 'Request Note',
    'admin_remark' => 'Admin Remark',
    'processed_at' => 'Processed at',
    'processed_by' => 'Processed by',
    'unauthorized_action' => 'Unauthorized action',
    'delivery_boy_withdrawals' => 'Delivery Boy Withdrawals',
    'seller_withdrawals' => 'Seller Withdrawals',
    'withdrawal_request_details' => 'Withdrawal Request Details',
    'withdrawal_history' => 'Withdrawal History',
    'process_request' => 'Process Request',
    'back' => 'Back',
    'withdrawal_request_information' => 'Withdrawal Request Information',
    'processing_information' => 'Processing Information',
    'transaction_type' => 'Transaction Type',
    'process_withdrawal_request' => 'Process Withdrawal Request',
    'confirm_withdrawal_request_message' => 'Are you sure you want to process this withdrawal request?',
    'pending_withdrawal_requests' => 'Pending Withdrawal Requests',
    'back_to_pending_requests' => 'Back to Pending Requests',

    // Withdrawal Service Labels
    'withdrawal_request_created_successfully' => 'Withdrawal request created successfully',
    'withdrawal_request_already_processed' => 'Withdrawal request already processed',
    'withdrawal_request_processed_successfully' => 'Withdrawal request processed successfully',
    'withdrawal_requests_retrieved_successfully' => 'Withdrawal requests retrieved successfully',
    'withdrawal_request_retrieved_successfully' => 'Withdrawal request retrieved successfully',
    'withdrawal_request_not_found' => 'Withdrawal request not found',

    'back_to_orders' => 'Back to Orders',
    'order_details' => 'Order Details',
    'order_summary' => 'Order Summary',
    'order_number' => 'Order Number',
    'order_date' => 'Order Date',
    'total_price' => 'Total Price',
    'customer_information' => 'Customer Information',
    'customer_name' => 'Customer Name',
    'shipping_address' => 'Shipping Address',
    'phone' => 'Phone',
    'order_items' => 'Order Items',
    'subtotal' => 'Subtotal',
    'total' => 'Total',
    'variant' => 'Variant',
    'shipped' => 'Shipped',
    'delivered' => 'Delivered',
    'returned' => 'Returned',
    'refunded' => 'Refunded',
    'completed' => 'Completed',
    'cancelled' => 'Cancelled',
    'select_items_to_update_status' => 'Select one or more items from the table above to update their status.',
    'amount_to_pay' => 'Amount to Pay',
    'your_commission' => 'Your Commission',

    // Wallet Labels
    'available_balance' => 'Available Balance',
    'current_balance' => 'Current Balance',
    'available_for_withdrawal' => 'Available for Withdrawal',
    'wallet_information' => 'Wallet Information',
    'wallet_id' => 'Wallet ID',
    'currency' => 'Currency',
    'blocked_balance' => 'Blocked Balance',
    'last_updated' => 'Last Updated',
    'transaction_history' => 'Transaction History',
    'back_to_wallet' => 'Back to Wallet',
    'back_to_withdrawals' => 'Back to Withdrawals',
    'withdrawals' => 'Withdrawals',
    'submit_request' => 'Submit Request',
    'add_new_product' => 'Add New Product',
    'dashboard' => 'Dashboard',
    'product_faqs' => 'Product Faqs',
    'tax_rates' => 'Tax Rates',
    'roles' => 'Roles',
    'roles_permissions' => 'Roles & Permissions',
    'system_user' => 'System User',

    // Dashboard Labels
    'sales' => 'Sales',
    'last_7_days' => 'Last 7 days',
    'last_30_days' => 'Last 30 days',
    'last_3_months' => 'Last 3 months',
    'conversion_rate' => 'Conversion rate',
    'delivered_out_of_total_orders' => 'delivered out of total orders',
    'complete' => 'Complete',
    'revenue' => 'Revenue',
    'store_revenue' => 'Store Revenue',
    'blocked' => 'Blocked',
    'active_users' => 'Active users',
    'total_reviews' => 'Total Reviews',
    'average_rating' => 'Average Rating',
    'unsettled_payments' => 'unsettled payments',
    'reviews' => 'reviews',
    'new_this_week' => 'new this week',
    'earnings_last_30_days' => 'Earnings (Last 30 Days)',
    'store_wise_order_distribution' => 'Store-wise Order Distribution',
    'seller_order_results' => 'Seller Order Results',
    'daily_orders_history' => 'Daily Orders History',
    'todays_earning' => 'Today\'s Earning',
    'more' => 'more',
    'less' => 'less',
    'than_yesterday' => 'than yesterday',
    'customer' => 'Customer',
    'feedback' => 'Feedback',
    'date' => 'Date',
    'no_feedback_available' => 'No feedback available',
    'no_orders_found' => 'No orders found',
    'orders' => 'Orders',
    'total' => 'Total',
    'recent_orders' => 'Recent Orders',
    'view_all_orders' => 'View All Orders',
    'total_orders' => 'Total Orders',
    'showing_recent' => 'Showing recent',
    'excellent' => 'Excellent',
    'very_good' => 'Very Good',
    'sold_by' => 'Sold By',
    'tax' => 'Tax',
    'product_status' => 'Product Status',
    'average' => 'Average',
    'poor' => 'Poor',
    'terrible' => 'Terrible',
    'select_a_rating' => 'Select a rating',

    // Product Detail View Labels
    'product_details' => 'Product Details',
    'product_summary' => 'Product Summary',
    'product_image' => 'Product Image',
    'product_description' => 'Product Description',
    'product_variants' => 'Product Variants',
    'product_pricing' => 'Product Pricing',
    'edit_product' => 'Edit Product',
    'store_wise_pricing' => 'Store-wise Pricing',
    'product_specifications' => 'Product Specifications',
    'is_cancelable' => 'Is Cancelable',
    'is_returnable' => 'Is Returnable',
    'returnable_days' => 'Returnable Days',
    'warranty_period' => 'Warranty Period',
    'guarantee_period' => 'Guarantee Period',
    'made_in' => 'Made In',
    'hsn_code' => 'HSN Code',
    'minimum_order_quantity' => 'Minimum Order Quantity',
    'quantity_step_size' => 'Quantity Step Size',
    'total_allowed_quantity' => 'Total Allowed Quantity',
    'is_inclusive_tax' => 'Is Inclusive Tax',
    'is_attachment_required' => 'Is Attachment Required',
    'base_prep_time' => 'Base Preparation Time',
    'video_type' => 'Video Type',
    'video_link' => 'Video Link',
    'tags' => 'Tags',
    'yes' => 'Yes',
    'no' => 'No',
    'days' => 'Days',
    'minutes' => 'Minutes',
    'seller_login' => 'Seller Login',
    'no_store_pricing_available' => 'No store pricing available',
    'order_commission_last_30_days' => 'Order Commission (Last 30 Days)',
    'total_delivery_boys' => 'Total Delivery',
    'active_delivery_boys' => 'Active Delivery Boys',
    'total_sales' => 'Total Sales',
    'new_user_registrations' => 'New User Registrations',
    'unsettled_payment' => 'Unsettled Payment',
    'weight' => 'Weight',
    'barcode' => 'Barcode',
    'height' => 'Height',
    'width' => 'Width',
    'length' => 'Length',
    'breadth' => 'Breadth',
    'faqs' => 'FAQs',
    'tax_groups' => 'Tax Groups',
    'add_new_role' => 'Add New Role',
    'system_users' => 'System Users',
    'add_new_user' => 'Add New User',
    'add_product_faq' => 'Add Product FAQ',
    'add_new_store' => 'Add New Store',

    // Delivery Feedback
    'delivery_feedback_fetched_successfully' => 'Delivery feedback fetched successfully.',
    'delivery_feedback_added_successfully' => 'Delivery feedback added successfully.',
    'delivery_feedback_updated_successfully' => 'Delivery feedback updated successfully.',
    'delivery_feedback_deleted_successfully' => 'Delivery feedback deleted successfully.',
    'delivery_feedback_not_found' => 'Delivery feedback not found.',
    'delivery_feedback_not_found_or_unauthorized' => 'Delivery feedback not found or you are not authorized.',
    'already_provided_feedback_for_this_delivery_boy' => 'You have already provided feedback for this delivery boy on this order.',
    'delivery_ratings_fetched_successfully' => 'Delivery ratings fetched successfully.',
    'delivery_boy_id_required' => 'Delivery boy ID is required.',
    'pending_orders_exist' => 'Pending orders exist for this delivery',
    'no_pending_orders_exist' => 'No pending orders exist for this',
    'you_cant_offline_with_pending_orders' => 'You cannot go offline with pending orders',
    'invalid_coordinates' => 'Invalid coordinates',
    'current_location_updated_successfully' => 'Current location updated successfully',
    'last_location_retrieved_successfully' => 'Last location retrieved successfully',
    'no_location_found' => 'No location found for this delivery',
    'order_not_found' => 'Order not found',
    'delivery_boy_not_assigned_yet' => 'Delivery Boy not assigned yet',
    'delivery_boy_location_not_found' => 'Delivery Boy Location Not Found',
    'order_delivered_already' => 'Order Already Delivered',

    // OTP related labels
    'requires_otp' => 'Requires OTP',
    'otp_required' => 'OTP is required',
    'invalid_otp' => 'Invalid OTP',
    'otp' => 'OTP',
    'otp_verified' => 'OTP Verified',
    'data_retrieved_successfully' => 'Data retrieved successfully',
    'date_range_retrieved_successfully' => 'Date range retrieved successfully',
    'store_id_or_slug_required' => 'Either Store ID or Store Slug is required',
    'store_not_found_with_slug' => 'Store not found with the provided slug',
    'product_not_found_with_slug' => 'Product not found with the provided slug',
    'home_page_fetched_successfully' => 'Home page fetched successfully',

    'instant' => 'Instant',
    'cashback' => 'Cashback',
    'select_promo_mode' => 'Select Promo Mode',
    'scope_category' => 'Scope Category',
    'invalid_scope_type' => 'Invalid Scope Type',
    'invalid_position_entered' => 'Invalid Position Entered',
    'category_slug_is_required' => 'Category Slug is Required',
    'background_type' => 'Background Type',
    'select_background_type' => 'Select Background Type',
    'color' => 'Color',
    'background_color' => 'Background Color',
    'font_color' => 'Font Color',
    'background_image' => 'Background Image',
    'desktop_4k_background_image' => 'Desktop 4K Background Image',
    'desktop_fdh_background_image' => 'Desktop FHD Background Image',
    'tablet_background_image' => 'Tablet Background Image',
    'mobile_background_image' => 'Mobile Background Image',
    'background_home_page_note' => 'This background will be displayed on the home page of the category.',
    'global_sections' => 'Global Sections',
    'global' => 'Global',
    'unknown_category' => 'Unknown Category',
    'icon' => 'Icon',
    'active_icon' => 'Active Icon',

    // Profile Management Labels
    'profile' => 'Profile',
    'edit_profile' => 'Edit Profile',
    'profile_information' => 'Profile Information',
    'manage_your_profile' => 'Manage Your Profile',
    'update_your_profile_information' => 'Update Your Profile Information',
    'profile_image' => 'Profile Image',
    'update_profile' => 'Update Profile',
    'profile_image_hint' => 'Supported formats: JPEG, PNG, JPG, WEBP. Maximum size: 2MB.',
    'email_cannot_be_changed' => 'Email address cannot be changed',
    'mobile_cannot_be_changed' => 'Mobile Number cannot be changed',
    'logout' => 'Logout',

        // Password change
        'current_password' => 'Current Password',
        'new_password' => 'New Password',
        'confirm_password' => 'Confirm Password',
        'update_password' => 'Update Password',
        'password_updated_successfully' => 'Password updated successfully',
        'password_update_failed' => 'Failed to update password: :error',

    // Notification Management Labels
    'notification_created_successfully' => 'Notification created successfully',
    'notification_retrieved_successfully' => 'Notification retrieved successfully',
    'notification_updated_successfully' => 'Notification updated successfully',
    'notification_deleted_successfully' => 'Notification deleted successfully',
    'notification_not_found' => 'Notification not found',
    'notifications_retrieved_successfully' => 'Notifications retrieved successfully',
    'error_retrieving_notifications' => 'Error retrieving notifications',
    'notification_marked_as_read' => 'Notification marked as read',
    'all_notifications_marked_as_read' => 'All notifications marked as read',
    'error_marking_notifications_as_read' => 'Error marking notifications as read',
    'unread_count_retrieved_successfully' => 'Unread count retrieved successfully',
    'error_retrieving_unread_count' => 'Error retrieving unread count',
    'sent_to' => 'Sent To',
    'message' => 'Message',
    'is_read' => 'Is Read',
    'read' => 'Read',
    'unread' => 'Unread',
    'mark_as_read' => 'Mark as Read',
    'mark_as_unread' => 'Mark as Unread',
    'mark_all_as_read' => 'Mark All as Read',
    'notifications' => 'Notifications',
    'notification_type' => 'Notification Type',
    'order' => 'Order',
    'delivery' => 'Delivery',
    'promotion' => 'Promotion',
    'user_notifications' => 'User Notifications',
    'admin_notifications' => 'Admin Notifications',
    'seller_notifications' => 'Seller Notifications',
    'customer_notifications' => 'Customer Notifications',
    'send_notification' => 'Send Notification',
    'payment_type' => 'Payment Type',
    'bulk_notifications' => 'Bulk Notifications',
    'notification_recipients' => 'Notification Recipients',
    'notification_content' => 'Notification Content',
    'push_notifications' => 'Push Notifications',
    'email_notifications' => 'Email Notifications',
    'sms_notifications' => 'SMS Notifications',

    // Header Notification Labels
    'new_report' => 'New Report',
    'user_registration' => 'User Registration',
    'system_update' => 'System Update',
    'database_backup' => 'Database Backup',
    'user_feedback' => 'User Feedback',
    'view_all_notifications' => 'View All Notifications',
    'no_notifications' => 'No notifications',
    'notification_marked_as_unread' => 'Notification marked as unread',
    'close' => 'Close',
    'notification_details' => 'Notification Details',
    'this_action_cannot_be_undone' => 'This action cannot be undone.',
    'yes_delete' => 'Yes, Delete',
    'confirm_mark_all_read' => 'Mark All as Read?',
    'mark_all_read_confirmation' => 'This will mark all notifications as read. Are you sure?',
    'yes_mark_all' => 'Yes, Mark All',
    'shipping_handling' => 'Shipping & Handling',
    'grand_total' => 'Grand Total',
    'total_payable' => 'Total Payable',
    'final_total' => 'Final Total',
    'add_store' => 'Add Store',

    // Language Labels
    'languages' => [
        'english' => 'English',
        'spanish' => 'Spanish',
        'french' => 'French',
        'german' => 'German',
        'chinese' => 'Chinese',
    ],
    'once_delivery_boy_verified_cant_be_changed' => 'Once delivery boy verified cannot be changed',
    'cash_remaining' => 'Cash Remaining',
    'center_coordinates' => 'Center Coordinates',
    'role' => 'Role',
    'user_created' => 'User created',

    // Product Approval Labels
    'product_approvals' => 'Product Approvals',
    'pending_product_approvals' => 'Pending Product Approvals',
    'approve' => 'Approve',
    'reject' => 'Reject',
    'rejection_reason' => 'Rejection Reason',
    'enter_rejection_reason' => 'Enter rejection reason',
    'rejection_reason_required' => 'Rejection reason is required',
    'product_approved_successfully' => 'Product approved successfully',
    'product_rejected_successfully' => 'Product rejected successfully',
    'reject_product' => 'Reject Product',
    'confirm_approve_product' => 'Approve this product?',
    'custom_fields' => 'Custom Fields',
    'payment_method_not_enabled' => ':payment_method payment method is not enabled.',
    'wallet_not_enabled' => 'Wallet is not enabled.',
    'store_configuration' => 'Store Configuration',
    'scheduling' => 'Scheduling',
    'attribute' => 'Attribute',
    'store_information' => 'Store Information',
    'delivery_settings' => 'Delivery Settings',
    'values_count' => 'Values Count',

    // Authentication Labels
    'forgot_password' => 'Forgot Password',
    'reset_password' => 'Reset Password',
    'no_unread_notifications' => 'No unread notifications',
    // Razorpay payment labels
    'razorpay_payment' => 'Razorpay Payment',
    'enable_razorpay_payment' => 'Enable Razorpay Payment',
    'razorpay_payment_mode' => 'Razorpay Payment Mode',
    'razorpay_payment_mode_placeholder' => 'Select Razorpay Payment Mode',
    'razorpay_key_id' => 'Razorpay Key ID',
    'razorpay_key_id_placeholder' => 'Enter Razorpay Key ID',
    'razorpay_secret_key' => 'Razorpay Secret Key',
    'razorpay_secret_key_placeholder' => 'Enter Razorpay Secret Key',
    'razorpay_webhook_secret' => 'Razorpay Webhook Secret',
    'razorpay_webhook_secret_placeholder' => 'Enter Razorpay Webhook Secret',
    'payment_variables_fetched_successfully' => 'Payment variables fetched successfully',
    'razorpay_payment_details_missing' => 'Razorpay payment details are missing',
    'order_payment_pending_cannot_update_status' => 'Order payment is pending, cannot update status',
    'payment_intent_created_successfully' => 'Payment intent created successfully',
    'payment_verified_successfully' => 'Payment verified successfully',
    'returnable_days_required_if' => 'Returnable days is required if the product is returnable',
    'rush_delivery_not_available_for_this_zone' => 'Rush Delivery Not Available for this Zone',
    'cancelable_till' => 'Cancelable Till',
    'cancelable_till_required_if' => 'Cancelable till is required if the product is cancelable',
    'unsupported_payment_method' => 'Unsupported payment method',
    'transactions_retrieved_successfully' => 'Transactions retrieved successfully',
    'google_login_not_enabled' => 'Google login is not enabled',
    'setting_not_found' => 'setting_not_found',
    'token_generated' => 'Token generated',
    'cannot_update_status_because_status_is_already' => 'Cannot Update Status Because Status is Already',
    'pwa_manifest_settings' => 'PWA Manifest Settings',
    'wallet_recharge_prepared_successfully' => 'Wallet recharge prepared successfully',
    'pwa_name' => 'PWA Name',
    'pwa_name_placeholder' => 'Enter PWA application name',
    'pwa_description' => 'PWA Description',
    'pwa_description_placeholder' => 'Enter a short description for the PWA',
    'pwa_logo_192x192' => 'PWA Logo (192x192)',
    'pwa_logo_512x512' => 'PWA Logo (512x512)',
    'pwa_logo_144x144' => 'PWA Logo (144x144)',
    'settings_fetched_successfully' => 'Settings Fetched Successfully',

    'enhanced_commissions' => 'Enhanced Commissions',

    'total_commission' => 'Total Commission',
    'avg_commission' => 'Avg. Commission',

    'top_sellers' => 'Top Sellers',
    'top_selling_products' => 'Top Selling Products',
    'top_delivery_boys' => 'Top Delivery Boys',

    'sold' => 'sold',
    'deliveries' => 'deliveries',

    'all_categories' => 'All Categories',
    'top_selling' => 'Top Selling',
    'no_products' => 'No Products',

    'sort_by_name' => 'Sort by Name',
    'sort_by_products_count' => 'Sort by Products Count',
    'sort_by_total_product_sold' => 'Sort by Total Product Sold',
    'seller_earning' => 'Seller Earning',
    'order_delivery_boy_location_retrieved_successfully' => 'Order delivery boy location retrieved successfully',
    'admin_commission_amount' => 'Admin Commission Amount',
    'paystack_payment' => 'Paystack Payment',
    'enable_paystack_payment' => 'Enable Paystack Payment',

    'paystack_payment_mode' => 'Paystack Payment Mode',
    'paystack_payment_mode_placeholder' => 'Select payment mode',

    'paystack_public_key' => 'Paystack Public Key',
    'paystack_public_key_placeholder' => 'Enter your Paystack public key',

    'paystack_secret_key' => 'Paystack Secret Key',
    'paystack_secret_key_placeholder' => 'Enter your Paystack secret key',

    'paystack_webhook_secret' => 'Paystack Webhook Secret',
    'paystack_webhook_secret_placeholder' => 'Enter your Paystack webhook secret',
    'paystack_currency_code' => 'Paystack Currency Code',
    'paystack_currency_code_placeholder' => 'select currency code supported by Paystack',
    'paystack_webhook_url_description' => 'Set this URL as your Paystack webhook URL to receive payment. Note: Do not forget to enable "Events" for "charge.success"',
    'flutterwave_payment' => 'Flutterwave Payment',
    'paystack_webhook_url' => 'Flutterwave Webhook URL',
    'enable_flutterwave_payment' => 'Enable Flutterwave Payment',
    'flutterwave_payment_mode' => 'Payment Mode',
    'flutterwave_payment_mode_placeholder' => 'Select payment mode',
    'flutterwave_public_key' => 'Public Key',
    'flutterwave_public_key_placeholder' => 'Enter Flutterwave Public Key',
    'flutterwave_secret_key' => 'Secret Key',
    'flutterwave_secret_key_placeholder' => 'Enter Flutterwave Secret Key',
    'flutterwave_encryption_key' => 'Encryption Key',
    'flutterwave_encryption_key_placeholder' => 'Enter Flutterwave Encryption Key',
    'flutterwave_webhook_secret' => 'Webhook Secret',
    'flutterwave_webhook_secret_placeholder' => 'Enter Webhook Secret',
    'flutterwave_currency_code' => 'Currency Code',
    'flutterwave_webhook_url' => 'Webhook URL',
    'flutterwave_webhook_url_description' => 'Use this URL in your Flutterwave dashboard under Webhooks.',
    'delivery_not_available_at_location' => 'Delivery not available at location',
    'search_labels' => 'Search labels',
    'eg_search_labels' => 'Eg. Search "coke", Search "shirt"',
    'search_labels_help' => 'Search labels will show in search bar.',
    'logo_and_banner' => 'Logo & Banner',
    'store_logo' => 'Store Logo',
    'store_banner' => 'Store Banner',

    // Currency Labels (optional, for display)
    'currency_data' => [
        'NGN' => 'Nigerian Naira (₦)',
        'GHS' => 'Ghanaian Cedi (₵)',
        'USD' => 'United States Dollar ($)',
        'GBP' => 'British Pound (£)',
        'EUR' => 'Euro (€)',
        'KES' => 'Kenyan Shilling (KSh)',
        'ZAR' => 'South African Rand (R)',
        'XAF' => 'Central African CFA Franc (FCFA)',
        'XOF' => 'West African CFA Franc (CFA)',
        'UGX' => 'Ugandan Shilling (USh)',
        'RWF' => 'Rwandan Franc (RF)',
        'TZS' => 'Tanzanian Shilling (TSh)',
        'ZMW' => 'Zambian Kwacha (ZK)',
        'XCD' => 'East Caribbean Dollar (EC$)',
        'CAD' => 'Canadian Dollar (C$)',
        'GMD' => 'Gambian Dalasi (D)',
        'SLL' => 'Sierra Leonean Leone (Le)',
        'MGA' => 'Malagasy Ariary (Ar)',
        'BWP' => 'Botswana Pula (P)',
        'EGP' => 'Egyptian Pound (E£)',
        'MAD' => 'Moroccan Dirham (MAD)',
        'GNF' => 'Guinean Franc (GNF)',
        'CDF' => 'Congolese Franc (FC)',
        'LRD' => 'Liberian Dollar (L$)',
        'MWK' => 'Malawian Kwacha (MK)',
        'SZL' => 'Swazi Lilangeni (E)',
        'SCR' => 'Seychellois Rupee (₨)',
        'MRU' => 'Mauritanian Ouguiya (UM)',
        'BIF' => 'Burundian Franc (FBu)',
        'KMF' => 'Comorian Franc (CF)',
        'STN' => 'São Tomé and Príncipe Dobra (Db)',
        'LSL' => 'Lesotho Loti (L)',
        'NAD' => 'Namibian Dollar (N$)',
    ],
    'invalid_status_provided' => 'Invalid status provided',
    'store_fetched_successfully' => 'Store fetched successfully',
    'main_image_required' => 'Main image is required',
    'product_not_returnable' => 'Product is not returnable',
    'order_item_cannot_be_returned_at_current_status' => 'Order item cannot be returned at current status',
    'return_deadline_expired' => 'The return deadline for this item has expired.',
    'return_requests' => 'Return Requests',
    'return_request' => 'Return Request',
    'return_request_sent' => 'Return request sent successfully.',
    'return_approved' => 'Return approved',
    'return_rejected' => 'Return rejected',

    // Table / UI labels
    'refund_amount' => 'Refund Amount',
    'pickup_status' => 'Pickup Status',
    'return_status' => 'Return Status',
    'view_images' => 'View Images',

    // Misc / prompts
    'confirm_approve_return' => 'Approve this return request?',
    'enter_reject_reason' => 'Optional: enter reason for rejection',
    'no_images' => 'No images available',
    'return_images' => 'Return Images',
    'return_not_found' => 'Return request not found',
    'return_already_processed' => 'This return request has already been processed',
    'invalid_status_transition' => 'Invalid status transition',
    'payment_return_settlements' => 'Payment & Return Settlement',
    'earning_deductions' => 'Earnings & Deductions',
    'payouts' => 'Payouts',
    'returns_deductions' => 'Returns & Deductions',
    'text_color' => 'Text Color',

    // Admin Menu Labels
    'seller_management' => 'Seller Management',
    'add_sellers' => 'Add New Seller',
    'earning_settlement' => 'Settlement Overview',
    'seller_withdrawal_history' => 'Withdrawal History',
    'pending_approval_products' => 'Pending Approval Products',
    'delivery_boy_management' => 'Manage Delivery Boys',
    'earning_history' => 'Earning History',
    'cash_collection_history' => 'Cash Collection History',
    'featured_section' => 'Manage Featured Section',
    'sort_featured_section' => 'Sort Featured Section',

    // Delivery Partner Menu Labels
    'delivery_partner_dashboard' => 'Dashboard',

    // Seller Menu Labels
    'seller_dashboard' => 'Dashboard',
    'earnings' => 'Settlements',
    'seller_orders' => 'Orders',
    'return_orders' => 'Return Orders',
    'seller_categories' => 'Categories',
    'seller_brands' => 'Brands',
    'manage_products' => 'Manage Products',
    'seller_products' => 'Products',
    'add_products' => 'Add Products',
    'seller_product_faqs' => 'Product FAQs',
    'seller_tax_rates' => 'Tax Rates',
    'seller_stores' => 'Stores',
    'seller_roles_permissions' => 'Roles & Permissions',
    'seller_roles' => 'Roles',
    'seller_system_users' => 'System Users',
    'seller_logout' => 'Logout',
    'menu_system' => 'System',
    'menu_web' => 'Web',
    'menu_app' => 'App',
    'menu_storage' => 'Storage',
    'menu_authentication' => 'Authentication',
    'menu_notification' => 'Notification',
    'menu_payment' => 'Payment',
    'valid_delivery_zone' => 'Valid Delivery Zone',
    'promo_discount' => 'Promo Discount',
    'user_updated' => 'User updated successfully',
    'attribute_values_updated_successfully' => 'Attribute values updated successfully',
    'attribute_updated_successfully' => 'Attribute updated successfully',
    'attribute_created_successfully' => 'Attribute created successfully',
    'attribute_values_created_successfully' => 'Attribute values created successfully',
    'special_price_less_than_price' => 'Special price cannot be less than price',
    'active_stores' => 'Active Stores',
    'no_unsettled_commissions_found' => 'No unsettled commissions found',
    'no_unsettled_debit_found' => 'No unsettled debit found',
    'attribute_and_values_deleted' => 'Attribute and its values deleted successfully',
    'failed_to_delete_attribute_and_values' => 'Failed to delete attribute and its values',
    'attribute_not_found' => 'Attribute not found',
    'failed_to_update_attribute' => 'Failed to update attribute',
    'no_permission_update_attribute' => 'No permission to update attribute',
    'attribute_used_in_variants' => 'Attribute is used in product variants',
    'role_already_exists' => 'Role already exists',
    'image_fit' => 'Image Fit',
    'apple_login_not_enabled' => 'Apple login is not enabled',
    'new_user' => 'New User',
    'demo_mode' => 'Demo Mode',
    'enable_demo_mode' => 'Enable Demo Mode',
    // Generic demo mode message (backward compatibility)
    'demo_mode_message_placeholder' => 'Demo mode is enabled. You can only view and manage demo stores.',
    'demo_mode_message' => 'Demo Mode Message',
    // Demo mode: specific roles/messages
    'admin_demo_mode_message' => 'Admin Demo Mode Message',
    'admin_demo_mode_message_placeholder' => 'Shown to admins when demo mode is enabled',
    'seller_demo_mode_message' => 'Seller Demo Mode Message',
    'seller_demo_mode_message_placeholder' => 'Shown to sellers when demo mode is enabled',
    'customer_demo_mode_message' => 'Customer Demo Mode Message',
    'customer_demo_mode_message_placeholder' => 'Shown to customers when demo mode is enabled',
    'customer_location_demo_mode_message' => 'Customer Location Demo Message',
    'customer_location_demo_mode_message_placeholder' => 'Shown when customer location features are limited in demo mode',
    'delivery_boy_demo_mode_message' => 'Delivery Partner Demo Mode Message',
    'delivery_boy_demo_mode_message_placeholder' => 'Shown to delivery partners when demo mode is enabled',
    // Demo credentials UI
    'demo_credentials' => 'Demo Credentials',
    'admin_credentials' => 'Admin Credentials',
    'seller_credentials' => 'Seller Credentials',
    'copy_and_fill' => 'Copy & Fill',

    // System Updates Page Labels
    'system_updates' => 'System Updates',
    'current_version' => 'Current Version',
    'upload_update_package' => 'Upload Update Package',
    'update_zip_file' => 'Update ZIP File',
    'update_zip_help' => 'Upload the update package in .zip format to apply system updates.',
    'apply_update' => 'Apply Update',
    'applying' => 'Applying…',
    'system_updated_successfully' => 'System updated successfully.',
    'no_update_permission' => 'You do not have permission to apply updates.',

    'latest_update_log' => 'Latest Update Log',
    'live_update_log' => 'Live Update Log',
    'starting' => 'Starting…',
    'processing' => 'Processing…',
    'applied' => 'Applied',
    'failed' => 'Failed',
    'copy' => 'Copy',
    'copied' => 'Copied',

    'update_history' => 'Update History',
    'version' => 'Version',
    'package' => 'Package',
    'status' => 'Status',
    'applied_by' => 'Applied By',
    'applied_at' => 'Applied At',
    'details' => 'Details',
    'view_log' => 'View Log',
    'system' => 'System',
    'no_updates_applied' => 'No updates have been applied yet.',
    'no_log_available' => 'No log available.',
    'log' => 'Log',
    'notes' => 'Notes',
    'cart_synced_successfully' => 'Cart synced successfully.',
    'order_note' => 'Order Note',
    'enable_wallet_payment' => 'Enable Wallet Payment',
    'wallet_payment_description' => 'Enable wallet payment for users to pay for orders using their wallet balance.',
];
